Imports Microsoft.VisualBasic
Imports System.Data
Imports System.Data.SqlClient

Public Class DiaryEvent
    Const conString As String = "Data Source=.\SQLEXPRESS;AttachDbFilename=|DataDirectory|\DiaryDB.mdf;Integrated Security=True;User Instance=True"
    Private mDiaryId As Integer = -1
    Private mEventId As Long = -1
    Private mEventName As String = "Wprowad nazw wydarzenia"
    Private mEventDescription As String = "Wprowad opis"
    Private mEventDate As Date
    Private mEventDuration As Integer
    Private mEventAttendees As New ContactCollection


#Region "Definicje waciwoci"

    Public Property EventName() As String
        Get
            EventName = mEventName
        End Get
        Set(ByVal value As String)
            mEventName = value
        End Set
    End Property

    Public Property EventDescription() As String
        Get
            EventDescription = mEventDescription
        End Get
        Set(ByVal value As String)
            mEventDescription = value
        End Set
    End Property

    Public Property EventDate() As Date
        Get
            EventDate = mEventDate
        End Get
        Set(ByVal value As Date)
            mEventDate = value
        End Set
    End Property

    Public Property EventDuration() As Integer
        Get
            EventDuration = mEventDuration
        End Get
        Set(ByVal value As Integer)
            mEventDuration = value
        End Set
    End Property

#End Region

#Region "Konstruktory"
    Public Sub New(ByVal DiaryId As Integer)
        mDiaryId = DiaryId
    End Sub

    Public Sub New(ByVal DiaryId As Integer, ByVal EventDate As Date)
        mDiaryId = DiaryId
        If mDiaryId <> -1 Then
            Try

                Dim diaryDBConn As New SqlConnection(conString)
                Dim sqlString As String = "GetDiaryEventByDate"
                Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
                sqlCmd.CommandType = CommandType.StoredProcedure

                sqlCmd.Parameters.AddWithValue("@DiaryId", mDiaryId)
                sqlCmd.Parameters.AddWithValue("@EntryFromDate", EventDate)
                sqlCmd.Parameters.AddWithValue("@EntryToDate", EventDate)

                diaryDBConn.Open()
                Dim diaryEventSQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
                diaryDBConn.Close()
                sqlCmd = Nothing
                diaryDBConn = Nothing
                If diaryEventSQLDR.Read() Then
                    mEventName = diaryEventSQLDR("EventName").ToString
                    mEventDescription = diaryEventSQLDR("EventDescription").ToString
                    mEventDate = CDate(diaryEventSQLDR("EventDate"))
                    mEventDuration = CInt(diaryEventSQLDR("EventDuration"))
                Else
                    mEventId = -1
                End If

                diaryEventSQLDR.Close()
                diaryEventSQLDR = Nothing
            Catch ex As Exception
                mEventId = -1
            End Try

        End If
    End Sub

    Public Sub New(ByVal EventId As Long)
        mEventId = EventId
        If mEventId <> -1 Then
            Try

                Dim diaryDBConn As New SqlConnection(conString)
                Dim sqlString As String = "GetDiaryEventById"
                Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
                sqlCmd.CommandType = CommandType.StoredProcedure

                sqlCmd.Parameters.AddWithValue("@EventId", mEventId)

                diaryDBConn.Open()
                Dim diaryEventSQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)

                sqlCmd = Nothing

                If diaryEventSQLDR.Read() Then
                    mEventName = diaryEventSQLDR("EventName").ToString
                    mEventDescription = diaryEventSQLDR("EventDescription").ToString
                    mEventDate = CDate(diaryEventSQLDR("EventDate"))
                    mEventDuration = CInt(diaryEventSQLDR("EventDuration"))
                    mDiaryId = CInt(diaryEventSQLDR("DiaryId"))

                    PopulateEventAttendeesCollection()

                Else
                    mEventId = -1
                End If

                diaryEventSQLDR.Close()
                diaryEventSQLDR = Nothing
                diaryDBConn.Close()
                diaryDBConn = Nothing
            Catch ex As Exception
                mEventId = -1
            End Try

        End If
    End Sub
#End Region

#Region "Skadniki prywatne"
    Private Sub InsertNewDiaryEvent()

        If mDiaryId <> -1 Then
            Dim diaryDBConn As New SqlConnection(conString)
            Dim sqlString As String = "InsertDiaryEvent"
            Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
            sqlCmd.CommandType = CommandType.StoredProcedure

            sqlCmd.Parameters.AddWithValue("@DiaryId", mDiaryId)
            sqlCmd.Parameters.AddWithValue("@EventName", mEventName)
            sqlCmd.Parameters.AddWithValue("@EventDescription", mEventDescription)
            sqlCmd.Parameters.AddWithValue("@EventDate", mEventDate)
            sqlCmd.Parameters.AddWithValue("@EventDuration", mEventDuration)
            sqlCmd.Parameters.Add("@NewEventId", SqlDbType.BigInt)
            sqlCmd.Parameters("@NewEventId").Direction = ParameterDirection.ReturnValue

            diaryDBConn.Open()
            sqlCmd.ExecuteNonQuery()
            mEventId = CLng(sqlCmd.Parameters("@NewEventId").Value())

            diaryDBConn.Close()
            sqlCmd = Nothing
            diaryDBConn = Nothing
        End If
    End Sub

    Private Sub UpdateDiaryEvent()
        If mEventId <> -1 Then
            Dim diaryDBConn As New SqlConnection(conString)
            Dim sqlString As String = "UpdateDiaryEvent"
            Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
            sqlCmd.CommandType = CommandType.StoredProcedure

            sqlCmd.Parameters.AddWithValue("@EventId", mEventId)
            sqlCmd.Parameters.AddWithValue("@EventName", mEventName)
            sqlCmd.Parameters.AddWithValue("@EventDescription", mEventDescription)
            sqlCmd.Parameters.AddWithValue("@EventDate", mEventDate)
            sqlCmd.Parameters.AddWithValue("@EventDuration", mEventDuration)

            diaryDBConn.Open()
            sqlCmd.ExecuteNonQuery()
            diaryDBConn.Close()
            sqlCmd = Nothing
            diaryDBConn = Nothing
        End If

    End Sub

    Private Sub DeleteEventAttendees()
        If mEventId <> -1 Then
            Dim diaryDBConn As New SqlConnection(conString)
            Dim sqlString As String = "DeleteEventAttendees"
            Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
            sqlCmd.CommandType = CommandType.StoredProcedure
            sqlCmd.Parameters.AddWithValue("@EventId", mEventId)

            diaryDBConn.Open()
            sqlCmd.ExecuteNonQuery()
            diaryDBConn.Close()
            sqlCmd = Nothing
            diaryDBConn = Nothing
        End If
    End Sub

    Private Sub InsertEventAttendee(ByVal ContactId As Long)
        If mEventId <> -1 Then
            Dim diaryDBConn As New SqlConnection(conString)
            Dim sqlString As String = "InsertEventAttendee"
            Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
            sqlCmd.CommandType = CommandType.StoredProcedure
            sqlCmd.Parameters.AddWithValue("@EventId", mEventId)
            sqlCmd.Parameters.AddWithValue("@ContactId", ContactId)
            diaryDBConn.Open()
            Try
                sqlCmd.ExecuteNonQuery()
            Catch ex As Exception
                diaryDBConn.Close()
                sqlCmd = Nothing
                diaryDBConn = Nothing
                Throw ex
            Finally
                diaryDBConn.Close()
                sqlCmd = Nothing
                diaryDBConn = Nothing
            End Try

        End If
    End Sub

    Private Sub PopulateEventAttendeesCollection()
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetEventAttendees"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@EventId", mEventId)

        diaryDBConn.Open()
        Dim eventAttendeesSQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
        sqlCmd = Nothing

        Do While eventAttendeesSQLDR.Read()
            mEventAttendees.Add(CLng(eventAttendeesSQLDR("ContactId")))
        Loop

        eventAttendeesSQLDR.Close()
        eventAttendeesSQLDR = Nothing
        diaryDBConn.Close()
        diaryDBConn = Nothing
    End Sub

#End Region

#Region "Wspdzielone funkcje publiczne"



    Public Shared Function GetDaysInMonthWithEvents(ByVal Diaryid As Integer, ByVal Month As Integer, ByVal Year As Integer) As Boolean()
        Dim DaysInMonth As Integer = System.DateTime.DaysInMonth(Year, Month)
        Dim DaysWithEvents(DaysInMonth) As Boolean
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetDaysWithEvents"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        Dim FromDate As New Date(Year, Month, 1)
        Dim ToDate As New Date(Year, Month, DaysInMonth)

        sqlCmd.Parameters.AddWithValue("@DiaryId", Diaryid)
        sqlCmd.Parameters.AddWithValue("@EventFromDate", FromDate)
        sqlCmd.Parameters.AddWithValue("@EventToDate", ToDate)

        diaryDBConn.Open()
        Dim EventSQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)

        sqlCmd = Nothing

        Do While EventSQLDR.Read()
            DaysWithEvents(CInt(EventSQLDR(0))) = True
        Loop

        EventSQLDR.Close()
        EventSQLDR = Nothing
        diaryDBConn.Close()
        diaryDBConn = Nothing

        Return DaysWithEvents

    End Function

    Public Shared Function GetDiaryEventsByDate(ByVal DiaryId As Integer, ByVal FromDate As Date, ByVal ToDate As Date, Optional ByVal MaxRows As Integer = 0) As SqlDataReader
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "GetDiaryEventByDate"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@DiaryId", DiaryId)
        sqlCmd.Parameters.AddWithValue("@EventFromDate", FromDate)
        sqlCmd.Parameters.AddWithValue("@EventToDate", ToDate)
        sqlCmd.Parameters.AddWithValue("@MaxRows", MaxRows)


        diaryDBConn.Open()
        Dim EventSQLDR As SqlDataReader = sqlCmd.ExecuteReader(CommandBehavior.CloseConnection)
        sqlCmd = Nothing
        Return EventSQLDR

    End Function

    Public Shared Function GetDiaryEventsByDateAsCollection(ByVal DiaryId As Integer, ByVal FromDate As Date, ByVal ToDate As Date) As DiaryEventCollection
        Dim DiaryEvents As New DiaryEventCollection
        Dim EventSQLDR As SqlDataReader = GetDiaryEventsByDate(DiaryId, FromDate, ToDate, 0)

        Do While EventSQLDR.Read()
            DiaryEvents.Add(CLng(EventSQLDR("DiaryEventId")))
        Loop

        EventSQLDR.Close()
        EventSQLDR = Nothing
        Return DiaryEvents
    End Function

    Public Shared Sub DeleteEvent(ByVal EventId As Long)
        Dim diaryDBConn As New SqlConnection(conString)
        Dim sqlString As String = "DeleteEvent"
        Dim sqlCmd As New SqlCommand(sqlString, diaryDBConn)
        sqlCmd.CommandType = CommandType.StoredProcedure

        sqlCmd.Parameters.AddWithValue("@EventId", EventId)
        diaryDBConn.Open()
        sqlCmd.ExecuteNonQuery()
        diaryDBConn.Close()
        sqlCmd = Nothing
        diaryDBConn = Nothing
    End Sub
#End Region

#Region "Funkcje publiczne"

    Public Sub DeleteEvent()
        If mEventId <> -1 Then
            DeleteEvent(mEventId)
        End If

    End Sub


    Public Sub Save()
        If mEventId = -1 Then
            InsertNewDiaryEvent()
        Else
            UpdateDiaryEvent()
            DeleteEventAttendees()
            Dim ContactCounter As Integer
            For ContactCounter = 0 To mEventAttendees.Count - 1
                InsertEventAttendee(mEventAttendees(ContactCounter).ContactId)
            Next
        End If
    End Sub
#End Region

End Class
